BPSB = require("scripts.bpsb")
Settings = require("scripts.settings")
Isolation = require("scripts.isolation")

data:extend({
    {
        type = "string-setting",
        name = Settings.isolationLevel,
        setting_type = "runtime-global",
        order = "a[common]-a",
        default_value = Isolation.none,
        allowed_values = {Isolation.none, Isolation.full},
    },
    {
        type = "bool-setting",
        name = Settings.allowAllTech,
        setting_type = "runtime-global",
        order = "a[common]-b",
        default_value = false,
    },
    {
        type = "bool-setting",
        name = Settings.onlyAdminsForceReset,
        setting_type = "runtime-global",
        order = "a[common]-c",
        default_value = false,
    },
    {
        type = "int-setting",
        name = Settings.bonusInventorySlots,
        setting_type = "runtime-global",
        order = "a[common]-d",
        default_value = 30,
        minimum_value = 0,
        maximum_value = 300,
    },
    {
        type = "int-setting",
        name = Settings.extraMiningSpeed,
        setting_type = "runtime-global",
        order = "a[common]-e",
        default_value = 1000000000,
        minimum_value = 0,
        maximum_value = 1000000000,
    },
    {
        type = "bool-setting",
        name = Settings.craftToCursor,
        setting_type = "runtime-per-user",
        order = "a[player]-b",
        default_value = true,
    },
    {
        type = "bool-setting",
        name = Settings.qualityEntityPlanners,
        setting_type = "runtime-per-user",
        order = "a[player]-c",
        default_value = false,
    },
    {
        type = "bool-setting",
        name = Settings.godBuilding,
        setting_type = "runtime-global",
        order = "b[god]-a",
        default_value = true,
    },
    {
        type = "int-setting",
        name = Settings.godAsyncTick,
        setting_type = "runtime-global",
        order = "b[god]-b",
        default_value = 15,
        minimum_value = 1,
        maximum_value = 120,
    },
    {
        type = "int-setting",
        name = Settings.godAsyncCreateRequestsPerTick,
        setting_type = "runtime-global",
        order = "b[god]-c",
        default_value = 0,
        minimum_value = 0,
        maximum_value = 10000,
    },
    {
        type = "int-setting",
        name = Settings.godAsyncUpgradeRequestsPerTick,
        setting_type = "runtime-global",
        order = "b[god]-d",
        default_value = 0,
        minimum_value = 0,
        maximum_value = 10000,
    },
    {
        type = "int-setting",
        name = Settings.godAsyncDeleteRequestsPerTick,
        setting_type = "runtime-global",
        order = "b[god]-e",
        default_value = 0,
        minimum_value = 0,
        maximum_value = 10000,
    },
    {
        type = "bool-setting",
        name = Settings.labsAbsorbPollution,
        setting_type = "startup",
        order = "a[lab]-a",
        default_value = true,
    },
    {
        type = "bool-setting",
        name = Settings.customLabTiles,
        setting_type = "startup",
        order = "a[lab]-b",
        default_value = true,
    },
})
